/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.ModelBase;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Entities {
    public static List<ElistInfo> entities = new ArrayList<ElistInfo>();
    public static Lock entity_list_lock = new ReentrantLock();

    public static void registerEntity(Class<? extends Entity> entityClass, String name, ModelBase model) {
        entity_list_lock.lock();
        ElistInfo el = new ElistInfo();
        el.uniquename = name;
        el.entclass = entityClass;
        el.model = model;
        entities.add(el);
        entity_list_lock.unlock();
    }

    public static Class<? extends Entity> findEntityByName(String name) {
        entity_list_lock.lock();
        for (ElistInfo st : entities) {
            if (!st.uniquename.equals(name)) continue;
            entity_list_lock.unlock();
            return st.entclass;
        }
        entity_list_lock.unlock();
        return null;
    }

    public static ElistInfo findElistInfoByName(String name) {
        entity_list_lock.lock();
        for (ElistInfo st : entities) {
            if (!st.uniquename.equals(name)) continue;
            entity_list_lock.unlock();
            return st;
        }
        entity_list_lock.unlock();
        return null;
    }

    public static Entity spawnEntityByName(String name, World w) {
        Entity ent = null;
        ElistInfo st = Entities.findElistInfoByName(name);
        if (st != null && st.entclass != null) {
            try {
                ent = st.entclass.getConstructor(World.class).newInstance(w);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return null;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return null;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                return null;
            }
            ent.model = st.model;
        }
        return ent;
    }

    public static Entity random_entity() {
        Entity retent = null;
        entity_list_lock.lock();
        int len = entities.size();
        if (len <= 0) {
            entity_list_lock.unlock();
            return retent;
        }
        if (len > 1) {
            len = DangerZone.rand.nextInt(len) + 1;
        }
        retent = Entities.spawnEntityByName(Entities.entities.get((int)(len - 1)).uniquename, null);
        entity_list_lock.unlock();
        return retent;
    }

    public static Entity random_livingentity() {
        Entity retent = null;
        entity_list_lock.lock();
        while (retent == null) {
            int len = entities.size();
            if (len <= 0) {
                entity_list_lock.unlock();
                return retent;
            }
            if (len > 1) {
                len = DangerZone.rand.nextInt(len) + 1;
            }
            if ((retent = Entities.spawnEntityByName(Entities.entities.get((int)(len - 1)).uniquename, null)) instanceof EntityLiving) continue;
            retent = null;
        }
        entity_list_lock.unlock();
        return retent;
    }

    public static class ElistInfo {
        public Class<? extends Entity> entclass;
        public ModelBase model;
        public String uniquename;
    }
}

